<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Live Map with Leaflet</title>
    <!-- Leaflet CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <!-- Leaflet JS -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <style>
        #map {
            width: 100%;
            height: 527px;
        }
    </style>
</head>
<body>
<?php  
if ($show_map == "Yes") {
    $dispatch_location = "6.5244,3.3792"; // Example coordinates for dispatch location
    $current_location = "6.5000,3.3500"; // Example coordinates for current location
?>
    <!-- Map Container -->
    <div id="map"></div>
    <script>
        // Initialize map
        const map = L.map('map').setView([6.5244, 3.3792], 13); // Center map on dispatch location

        // Add OpenStreetMap tiles (no API key required)
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: '© OpenStreetMap contributors'
        }).addTo(map);

        // Add markers for dispatch and current locations
        const dispatchCoords = [<?php echo $dispatch_location; ?>];
        const currentCoords = [<?php echo $current_location; ?>];

        const dispatchMarker = L.marker(dispatchCoords).addTo(map).bindPopup('Dispatch Location').openPopup();
        const currentMarker = L.marker(currentCoords, { icon: L.icon({ 
            iconUrl: 'https://cdn-icons-png.flaticon.com/512/684/684908.png', 
            iconSize: [25, 41], 
            iconAnchor: [12, 41] 
        }) }).addTo(map).bindPopup('Current Location');

        // Draw a line between dispatch and current locations
        const line = L.polyline([dispatchCoords, currentCoords], { color: 'red' }).addTo(map);

        // Simulate live movement of current location
        function simulateMovement() {
            let step = 0.001; // Define movement step
            setInterval(() => {
                currentCoords[0] += step; // Increment latitude
                currentCoords[1] += step; // Increment longitude
                
                // Update marker and line
                currentMarker.setLatLng(currentCoords);
                line.setLatLngs([dispatchCoords, currentCoords]);

                // Adjust map view
                map.setView(currentCoords);
            }, 1000); // Update every second
        }

        simulateMovement(); // Start simulation
    </script>
<?php } ?>
</body>
</html>
