<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Live Map</title>
    <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY"></script>
    <style>
        #map {
            width: 100%;
            height: 527px;
        }
    </style>
</head>
<body>
<?php  
if ($show_map == "Yes") {
    $dispatch_location = "6.5244,3.3792"; // Example coordinates for dispatch location
    $current_location = "6.5000,3.3500"; // Example coordinates for current location
?>
    <!-- Map Container -->
    <div id="map"></div>
    <script>
        let map, dispatchMarker, currentMarker, line;

        // Initialize the map
        function initMap() {
            const dispatchLocation = { lat: <?php echo explode(',', $dispatch_location)[0]; ?>, lng: <?php echo explode(',', $dispatch_location)[1]; ?> };
            const currentLocation = { lat: <?php echo explode(',', $current_location)[0]; ?>, lng: <?php echo explode(',', $current_location)[1]; ?> };

            // Create the map
            map = new google.maps.Map(document.getElementById('map'), {
                center: dispatchLocation,
                zoom: 13,
                mapTypeId: 'roadmap'
            });

            // Add markers
            dispatchMarker = new google.maps.Marker({
                position: dispatchLocation,
                map: map,
                title: "Dispatch Location"
            });

            currentMarker = new google.maps.Marker({
                position: currentLocation,
                map: map,
                title: "Current Location",
                icon: "http://maps.google.com/mapfiles/ms/icons/green-dot.png"
            });

            // Draw a line
            line = new google.maps.Polyline({
                path: [dispatchLocation, currentLocation],
                geodesic: true,
                strokeColor: "#FF0000",
                strokeOpacity: 1.0,
                strokeWeight: 2,
                map: map
            });

            // Simulate live movement
            simulateMovement(currentLocation);
        }

        // Function to simulate movement
        function simulateMovement(currentLocation) {
            let step = 0.001; // Movement step
            setInterval(() => {
                // Update current location
                currentLocation.lat += step;
                currentLocation.lng += step;

                // Update marker position
                currentMarker.setPosition(currentLocation);

                // Update line
                line.setPath([dispatchMarker.getPosition(), currentLocation]);

                // Re-center map
                map.setCenter(currentLocation);
            }, 1000); // Update every second
        }

        // Load the map
        window.onload = initMap;
    </script>
<?php } ?>
</body> 
</html>
